import { config } from '@/constants/Api_config'
import { HttpClient } from '@/Api_Classes/HttpClient'

const BASE_API_URL = config.API_BASE_URL

class EventsRepository {
  private readonly httpClient: HttpClient

  constructor(baseUrl: string) {
    this.httpClient = new HttpClient(baseUrl)
  }

  getEvents(params: {
    localId?: number
    name?: string
    eventType?: string
    eventStatus?: string
    sortBy?: string
    direction?: string
    page?: number
    size?: number
  }) {
    return this.httpClient.get('', {
      queryParams: {
        localId: params.localId,
        name: params.name,
        eventType: params.eventType,
        eventStatus: params.eventStatus,
        sortBy: params.sortBy,
        direction: params.direction,
        page: params.page ?? 0,
        size: params.size ?? 10,
      },
    })
  }
}

export const useEvents = new EventsRepository(BASE_API_URL + '/api/events')
