import { config } from '@/constants/Api_config'
import { HttpClient } from '@/Api_Classes/HttpClient'

const BASE_API_URL = config.API_BASE_URL

class Locale {
  private readonly httpClient: HttpClient

  constructor(baseUrl: string) {
    this.httpClient = new HttpClient(baseUrl)
  }

  getLocals(params: {
    name?: string
    sortBy?: string
    direction?: string
    isOpen?: boolean
    page?: number
    size?: number
  }) {
    return this.httpClient.get('', {
      queryParams: {
        name: params.name,
        sortBy: params.sortBy,
        direction: params.direction,
        isOpen: params.isOpen,
        page: params.page ?? 0,
        size: params.size ?? 10,
      },
    })
  }

  getSpecificLocale(localeId: number) {
    return this.httpClient.get(`${localeId}`)
  }
}

export const useLocales = new Locale(BASE_API_URL + '/api/locals')
