package mk.ukim.finki.it.reservengo.service.intf;

import mk.ukim.finki.it.reservengo.dto.localDTO.CreateLocalDetailsDTO;
import mk.ukim.finki.it.reservengo.model.domain.Local;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

public interface LocalService {
    List<Local> listAll();

    Local findLocalById(Long id);

    void save(String name);

    void delete(Long id);

    void addLogo(Long localId, MultipartFile multipartFile);

    void deleteLogo(Long localId);

    void uploadPhotos(Long localId, List<MultipartFile> photos);

    void deletePhotos(Long localId, List<String> photoPaths);

    void uploadMenu(Long localId, MultipartFile localMenuFile);

    void deleteMenu(Long localId);

    void updateInfoLocal(Long localId, CreateLocalDetailsDTO createLocalDetailsDTO);
}
