package mk.ukim.finki.it.reservengo.service.intf;

import mk.ukim.finki.it.reservengo.dto.localDTO.CreateLocalDetailsDTO;
import mk.ukim.finki.it.reservengo.model.domain.Local;
import mk.ukim.finki.it.reservengo.model.domain.LocalManager;
import mk.ukim.finki.it.reservengo.model.enumerations.Position;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

public interface LocalManagerService {
    void save(LocalManager localManager);

    List<LocalManager> findAllByLocalId(Long localId);

    List<LocalManager> findAll();

    LocalManager findManagerById(Long id);

    List<LocalManager> findAllUnassigned();

    void updateLocalAssignment(LocalManager manager, Local local, Position position);

    Local findLocalByManagerId(Long id);

    Local editLocal(Long managerId, CreateLocalDetailsDTO createLocalDetailsDTO);

    String uploadLocalLogo(Long managerId, MultipartFile logoFile);

    void deleteLocalLogo(Long managerId);

    void uploadLocalPhotos(Long localId, List<MultipartFile> photos);

    void deleteLocalPhotos(Long localId, List<String> photoPaths);
}
