package mk.ukim.finki.it.reservengo.model.domain;

import jakarta.persistence.*;
import mk.ukim.finki.it.reservengo.model.enumerations.Service;

import java.util.List;
import java.util.Map;


@Entity
@Table(name = "local_")
public class Local {
    public Local(String name, String description, String address, String workingHours, List<Service> availableServices, Map<Long, Integer> ratings, List<Event> events, List<String> localPhotos, String menuPhoto, String menuLink, Contact contact, List<Reservation> reservations, List<LocalWorker> workers) {
        this.name = name;
        this.description = description;
        this.address = address;
        this.workingHours = workingHours;
        this.availableServices = availableServices;
        this.ratings = ratings;
        this.events = events;
        this.localPhotos = localPhotos;
        this.menuPhoto = menuPhoto;
        this.menuLink = menuLink;
        this.contact = contact;
        this.reservations = reservations;
        this.workers = workers;
    }

    public Local(String name) {
        this.name = name;
    }


    public Local() {
    }

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    private String name;

    private String description;

    private String address;

    private String workingHours;

    @Enumerated(EnumType.STRING)
    @ElementCollection
    private List<Service> availableServices;

    @ElementCollection
    @MapKeyColumn(name = "customer_id")
    private Map<Long, Integer> ratings;

    @OneToMany(mappedBy = "local", cascade = CascadeType.ALL)
    private List<Event> events;

    @ElementCollection
    private List<String> localPhotos;

    private String menuPhoto;

    private String menuLink;

    @Embedded
    private Contact contact;

    @OneToMany(mappedBy = "local", cascade = CascadeType.ALL)
    private List<Reservation> reservations;

    @OneToMany(mappedBy = "local")
    private List<LocalWorker> workers;

    private String logoUrl;

    public double calculateLocalAverageRating() {
        if (ratings == null || ratings.isEmpty()) {
            return 0.0;
        }
        double sum = 0.0;
        for (Integer rating : ratings.values()) {
            sum += rating;
        }
        return sum / ratings.size();
    }


    public Long getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getDescription() {
        return description;
    }

    public String getAddress() {
        return address;
    }

    public String getWorkingHours() {
        return workingHours;
    }

    public List<Service> getAvailableServices() {
        return availableServices;
    }

    public Map<Long, Integer> getRatings() {
        return ratings;
    }

    public List<Event> getEvents() {
        return events;
    }

    public List<String> getLocalPhotos() {
        return localPhotos;
    }

    public String getMenuPhoto() {
        return menuPhoto;
    }

    public String getMenuLink() {
        return menuLink;
    }

    public Contact getContact() {
        return contact;
    }

    public List<Reservation> getReservations() {
        return reservations;
    }

    public List<LocalWorker> getWorkers() {
        return workers;
    }

    public String getLogoUrl() {
        return logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }
}