package mk.ukim.finki.it.reservengo.web;

import mk.ukim.finki.it.reservengo.service.intf.LocalManagerService;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping("/api/local-manager")
public class LocalManagerController {

    private final LocalManagerService localManagerService;

    public LocalManagerController(LocalManagerService localManagerService) {
        this.localManagerService = localManagerService;
    }

    @PostMapping("/{localId}/upload-logo")
    public ResponseEntity<?> uploadLogo(@PathVariable Long localId,
                                        @RequestParam("logo") MultipartFile logoFile) {
        localManagerService.uploadLogo(localId, logoFile);
        return ResponseEntity.ok().build();
    }

}
