package mk.ukim.finki.it.reservengo.service.impl;

import jakarta.transaction.Transactional;
import mk.ukim.finki.it.reservengo.model.Customer;
import mk.ukim.finki.it.reservengo.model.Local;
import mk.ukim.finki.it.reservengo.model.exceptions.CustomerNotFoundException;
import mk.ukim.finki.it.reservengo.model.exceptions.LocalNotFoundException;
import mk.ukim.finki.it.reservengo.repository.CustomerRepository;
import mk.ukim.finki.it.reservengo.repository.LocalRepository;
import mk.ukim.finki.it.reservengo.service.intf.CustomerService;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class CustomerServiceImpl implements CustomerService {
    private final CustomerRepository customerRepository;
    private final LocalRepository localRepository;

    public CustomerServiceImpl(CustomerRepository customerRepository, LocalRepository localRepository) {
        this.customerRepository = customerRepository;
        this.localRepository = localRepository;
    }

    @Override
    public Customer getCustomerProfile(Long id) {
        return customerRepository.findById(id).orElseThrow(() -> new CustomerNotFoundException(id));
    }

    @Override
    public List<Local> listFavouriteLocals(Long id) {
        Customer customer = customerRepository.findById(id).orElseThrow(() -> new CustomerNotFoundException(id));
        return customer.getFavouriteLocals();
    }

    @Override
    public void addFavouriteLocal(Long userId, Long localId) {
        Customer customer = customerRepository.findById(userId).orElseThrow(() -> new CustomerNotFoundException(userId));
        Local local = localRepository.findById(localId).orElseThrow(() -> new LocalNotFoundException(localId));

        if (!customer.getFavouriteLocals().contains(local)) {
            customer.getFavouriteLocals().add(local);
        }

        customerRepository.save(customer);
    }

    @Override
    public void removeFavouriteLocal(Long userId, Long localId) {
        Customer customer = customerRepository.findById(userId).orElseThrow(() -> new CustomerNotFoundException(userId));
        Local local = localRepository.findById(localId).orElseThrow(() -> new LocalNotFoundException(localId));

        customer.getFavouriteLocals().remove(local);

        customerRepository.save(customer);
    }
}
