import { ApiClient } from '@/Api_Classes/ApiClient'
import { config } from '@/constants/Api_config'
import { HttpClient } from '@/Api_Classes/HttpClient'

const BASE_API_URL = config.API_BASE_URL

/*
console.warn("THIS IS THE BASE URL",BASE_API_URL)
*/

class LocalManager {
  private readonly httpClient: HttpClient

  constructor(baseUrl: string) {
    this.httpClient = new HttpClient(baseUrl)
  }

  uploadLogo(formData: FormData): Promise<any> {
    return this.httpClient.upload('upload-logo', formData)
  }
  uploadImage(formData: FormData): Promise<any> {
    return this.httpClient.upload('upload-photo', formData)
  }
  deletePhoto(photoUrls : Object): Promise<any> {
    /*if (typeof photoUrls === 'string') {photoUrls = [photoUrls] }*/
    return this.httpClient.delete('delete-photos', photoUrls)
  }
  getLocal(): Promise<any> {
    return this.httpClient.get('my-local');
  }

}

export const useLocalManager = new LocalManager(BASE_API_URL + '/api/local-manager/', )
