import { config } from '@/constants/Api_config'
import { HttpClient } from '@/Api_Classes/HttpClient'
import { ReservationStatus } from '@/repository/Reservations'

const BASE_API_URL = config.API_BASE_URL

export type DashboardReservationDisplayDTO = {
  reservationId?: number | string
  customerName?: string
  customerId?: number | string
  timeOfReservation: string
  tableCapacity: number
  reservationStatus: ReservationStatus
}

class LocalWorker {
  private readonly httpClient: HttpClient

  constructor(baseUrl: string) {
    this.httpClient = new HttpClient(baseUrl)
  }

  getReservations(): Promise<DashboardReservationDisplayDTO[]> {
    return this.httpClient.get('reservations')
  }

  acceptReservation(reservationId: number): Promise<any> {
    return this.httpClient.put(`reservations/${reservationId}/accept`)
  }

  denyReservation(reservationId: number): Promise<any> {
    return this.httpClient.put(`reservations/${reservationId}/deny`)
  }

  finishReservation(reservationId: number): Promise<any> {
    return this.httpClient.put(`reservations/${reservationId}/finish`)
  }

  // DELETE /api/local-worker/reservations/delete
  deleteReservations(dto: { reservationIds: Array<number | string> }): Promise<void> {
    return this.httpClient.delete('reservations/delete', dto)
  }
}

export const useLocalWorker = new LocalWorker(BASE_API_URL + '/api/local-worker')
