import { config } from '@/constants/Api_config'
import { HttpClient } from '@/Api_Classes/HttpClient'

const BASE_API_URL = config.API_BASE_URL

class EventsRepository {
  private readonly httpClient: HttpClient

  constructor(baseUrl: string) {
    this.httpClient = new HttpClient(baseUrl)
  }

  getEvents(params: {
    localId?: number
    name?: string
    eventType?: string
    eventStatus?: string
    sortBy?: string
    direction?: string
    page?: number
    size?: number
  }) {
    const queryParams: any = {}

    Object.entries(params).forEach(([key, value]) => {
      if (value !== undefined && value !== null) {
        queryParams[key] = value
      }
    })

    return this.httpClient.get('', { queryParams })
  }
}

export const useEvents = new EventsRepository(BASE_API_URL + '/api/events')
