import { config } from '@/constants/Api_config'
import { HttpClient } from '@/Api_Classes/HttpClient'

const BASE_API_URL = config.API_BASE_URL

class Locale {
  private readonly httpClient: HttpClient

  constructor(baseUrl: string) {
    this.httpClient = new HttpClient(baseUrl)
  }

  getLocals(params: {
    name?: string
    services?: string[]
    localType?: string
    isOpen?: boolean | null
    sortBy?: string
    direction?: string
    page?: number
    size?: number
  }) {
    const queryParams: any = {}

    Object.entries(params).forEach(([key, value]) => {
      if (value !== undefined && value !== null && !(Array.isArray(value) && value.length === 0)) {
        queryParams[key] = value
      }
    })

    return this.httpClient.get('', { queryParams })
  }

  getSpecificLocale(localeId: number) {
    return this.httpClient.get(`${localeId}`)
  }
}

export const useLocales = new Locale(BASE_API_URL + '/api/locals')
