package mk.ukim.finki.it.reservengo.dto.contactDTO;

import mk.ukim.finki.it.reservengo.model.domain.Contact;

import java.util.Map;

public record ContactDTO(
        String phone,
        String email,
        Map<String, String> socialLinks
) {
    public static ContactDTO from(Contact contact) {
        return new ContactDTO(
                contact.getPhone(),
                contact.getEmail(),
                contact.getSocialLinks()
        );
    }

    public Contact toContact() {
        return new Contact(
                phone, email, socialLinks
        );
    }
}
