package mk.ukim.finki.it.reservengo.dto.jwtDTO;

import mk.ukim.finki.it.reservengo.model.domain.User;
import mk.ukim.finki.it.reservengo.model.enumerations.Role;


public record JWTAuthenticationResponseDTO(
        Long id,
        String firstName,
        String lastName,
        String email,
        String logoUrl,
        Role role,
        String token
) {
    public static JWTAuthenticationResponseDTO fromUser(User user, String jwt) {
        return new JWTAuthenticationResponseDTO(
                user.getId(),
                user.getFirstName(),
                user.getLastName(),
                user.getEmail(),
                user.getProfilePhotoUrl(),
                user.getUserRole(),
                jwt
        );
    }
}
