package mk.ukim.finki.it.reservengo.dto.localDTO;

import org.springframework.data.domain.Page;


import java.util.List;

public record PagedLocalDTO(
        List<DisplayLocalDTO> locals,
        int currentPage,
        int totalPages,
        long itemsPerPage
) {
    public static PagedLocalDTO from(Page<DisplayLocalDTO> page) {
        return new PagedLocalDTO(
                page.getContent(),
                page.getNumber(),
                page.getTotalPages(),
                page.getTotalElements()
        );
    }
}
