package mk.ukim.finki.it.reservengo.dto.localDTO;

import mk.ukim.finki.it.reservengo.model.domain.WorkingHour;

import java.time.DayOfWeek;
import java.time.LocalTime;
import java.util.List;

public record WorkingHourDTO(
        DayOfWeek dayOfWeek,
        LocalTime openTime,
        LocalTime closeTime
) {
    public static WorkingHourDTO from(WorkingHour workingHour) {
        return new WorkingHourDTO(
                workingHour.getDayOfWeek(),
                workingHour.getOpenTime(),
                workingHour.getCloseTime()
        );
    }

    public static List<WorkingHourDTO> from(List<WorkingHour> workingHours) {
        return workingHours.stream()
                .map(WorkingHourDTO::from)
                .toList();
    }

    public WorkingHour to() {
        return new WorkingHour(
                dayOfWeek,
                openTime,
                closeTime
        );
    }

    public static List<WorkingHour> to(List<WorkingHourDTO> list) {
        return list.stream()
                .map(WorkingHourDTO::to)
                .toList();
    }
}
