package mk.ukim.finki.it.reservengo.model.domain;

import jakarta.persistence.*;
import lombok.*;

import java.time.LocalDateTime;

@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
public class Event {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @ManyToOne
    private Local local;

    private String name;

    private String description;

    private LocalDateTime eventStart;

    private LocalDateTime eventEnd;

    public Event(String name, String description, LocalDateTime eventStart, LocalDateTime eventEnd, Local local) {
        this.name = name;
        this.description = description;
        this.eventStart = eventStart;
        this.eventEnd = eventEnd;
        this.local = local;
    }
}
