package mk.ukim.finki.it.reservengo.bootstrap;

import jakarta.annotation.PostConstruct;
import mk.ukim.finki.it.reservengo.model.domain.*;
import mk.ukim.finki.it.reservengo.model.enumerations.EventType;
import mk.ukim.finki.it.reservengo.model.enumerations.LocalType;
import mk.ukim.finki.it.reservengo.model.enumerations.Role;
import mk.ukim.finki.it.reservengo.model.enumerations.ProvidedService;
import mk.ukim.finki.it.reservengo.repository.*;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;

import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Component
public class DataHolder {
    public static Admin admin = null;
    public static List<Customer> customers = new ArrayList<>();
    public static List<LocalWorker> workers = new ArrayList<>();
    public static List<LocalManager> managers = new ArrayList<>();
    public static List<Local> locals = new ArrayList<>();
    public static List<Event> events = new ArrayList<>();

    private final AdminRepository adminRepository;
    private final CustomerRepository customerRepository;
    private final LocalManagerRepository localManagerRepository;
    private final LocalRepository localRepository;
    private final LocalWorkerRepository localWorkerRepository;
    private final PasswordEncoder passwordEncoder;
    private final EventRepository eventRepository;

    public DataHolder(AdminRepository adminRepository, CustomerRepository customerRepository, LocalManagerRepository localManagerRepository, LocalRepository localRepository, LocalWorkerRepository localWorkerRepository, PasswordEncoder passwordEncoder, EventRepository eventRepository) {
        this.adminRepository = adminRepository;
        this.customerRepository = customerRepository;
        this.localManagerRepository = localManagerRepository;
        this.localRepository = localRepository;
        this.localWorkerRepository = localWorkerRepository;
        this.passwordEncoder = passwordEncoder;
        this.eventRepository = eventRepository;
    }

    @PostConstruct
    public void init() {
        // Admin
        admin = new Admin("admin", passwordEncoder.encode("admin"), Role.ROLE_ADMIN);
        adminRepository.save(admin);

        // Customers
        for (int i = 1; i <= 3; i++) {
            Customer customer = new Customer(
                    "FirstName " + i,
                    "LastName " + i,
                    "customer" + i + "@example.com",
                    passwordEncoder.encode("password" + i),
                    "Phone" + i,
                    Role.ROLE_CUSTOMER
            );
            customers.add(customer);
        }
        customerRepository.saveAll(customers);

        //Local worker
        for (int i = 1; i <= 3; i++) {
            LocalWorker localWorker = new LocalWorker(
                    "FirstName" + i,
                    "LastName" + i,
                    "worker" + i + "@example.com",
                    passwordEncoder.encode("password" + i),
                    "Phone" + i,
                    Role.ROLE_LOCAL_WORKER
            );
            workers.add(localWorker);
        }
        localWorkerRepository.saveAll(workers);

        //Local manager
        for (int i = 1; i <= 3; i++) {
            LocalManager manager = new LocalManager(
                    "FirstName" + i,
                    "LastName" + i,
                    "manager" + i + "@example.com",
                    passwordEncoder.encode("password" + i),
                    "Phone" + i,
                    Role.ROLE_LOCAL_MANAGER
            );
            managers.add(manager);
        }
        localManagerRepository.saveAll(managers);

        //Local
        List<ProvidedService> serviceList = new ArrayList<>(Arrays.asList(ProvidedService.values()));
        for (int i = 1; i <= 3; i++) {
            Local local = new Local(
                    "Name" + i,
                    "Description" + i,
                    "Address" + i,
                    new ArrayList<>(Arrays.asList(
                            new WorkingHour(DayOfWeek.MONDAY, LocalTime.of(9, 0), LocalTime.of(17, 0)),
                            new WorkingHour(DayOfWeek.TUESDAY, LocalTime.of(9, 0), LocalTime.of(17, 0)),
                            new WorkingHour(DayOfWeek.WEDNESDAY, LocalTime.of(9, 0), LocalTime.of(17, 0)),
                            new WorkingHour(DayOfWeek.SATURDAY, LocalTime.of(9, 0), LocalTime.of(21, 0))
                    )),
                    serviceList,
                    null,
                    null,
                    "LogoURL" + i,
                    null,
                    "MenuLink" + i,
                    null,
                    null,
                    LocalType.RESTAURANT
            );

            locals.add(local);
        }
        localRepository.saveAll(locals);

        for (Local local : locals) {
            // Active event
            Event activeEvent = new Event(
                    "Active Event for " + local.getName(),
                    "Description for active event",
                    EventType.DJ_NIGHT,
                    LocalDateTime.now().plusDays(7), // Future date
                    LocalDateTime.now().plusDays(8),
                    local
            );

            // Finished event
            Event finishedEvent = new Event(
                    "Finished Event for " + local.getName(),
                    "Description for finished event",
                    EventType.BRUNCH,
                    LocalDateTime.now().minusDays(7), // Past date
                    LocalDateTime.now().minusDays(6),
                    local
            );

            events.add(activeEvent);
            events.add(finishedEvent);
        }
        eventRepository.saveAll(events);
    }
}