package mk.ukim.finki.it.reservengo.model.domain;

import jakarta.persistence.*;
import lombok.*;
import mk.ukim.finki.it.reservengo.config.listeners.Auditable;
import mk.ukim.finki.it.reservengo.model.enumerations.ReservationStatus;

import java.util.Map;

@EqualsAndHashCode(callSuper = true)
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
public class Reservation extends Auditable {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @ManyToOne
    private Customer customer;

    @ManyToOne
    private Local local;

    @ElementCollection
    @MapKeyColumn(name = "table_id")
    @Column(name = "num_people")
    private Map<Integer, Integer> reservedTables;

    @Enumerated(EnumType.STRING)
    private ReservationStatus status;
}
