package mk.ukim.finki.it.reservengo.dto.jwtDTO;

import mk.ukim.finki.it.reservengo.model.domain.Customer;
import mk.ukim.finki.it.reservengo.model.domain.LocalManager;
import mk.ukim.finki.it.reservengo.model.domain.LocalWorker;
import mk.ukim.finki.it.reservengo.model.domain.User;
import mk.ukim.finki.it.reservengo.model.enumerations.Role;


public record JWTAuthenticationResponseDTO(
        Long id,
        String firstName,
        String lastName,
        String email,
        String phoneNumber,
        Role role,
        String token
) {

    public static JWTAuthenticationResponseDTO fromCustomer(Customer customer, String jwt) {
        return new JWTAuthenticationResponseDTO(
                customer.getId(),
                customer.getFirstName(),
                customer.getLastName(),
                customer.getEmail(),
                customer.getPhoneNumber(),
                Role.ROLE_CUSTOMER,
                jwt
        );
    }

    public static JWTAuthenticationResponseDTO fromLocalWorker(LocalWorker localWorker, String jwt) {
        return new JWTAuthenticationResponseDTO(
                localWorker.getId(),
                localWorker.getFirstName(),
                localWorker.getLastName(),
                localWorker.getEmail(),
                localWorker.getPhoneNumber(),
                Role.ROLE_LOCAL_WORKER,
                jwt
        );
    }

    public static JWTAuthenticationResponseDTO fromLocalManager(LocalManager localManager, String jwt) {
        return new JWTAuthenticationResponseDTO(
                localManager.getId(),
                localManager.getFirstName(),
                localManager.getLastName(),
                localManager.getEmail(),
                localManager.getPhoneNumber(),
                Role.ROLE_LOCAL_MANAGER,
                jwt
        );
    }

    public static JWTAuthenticationResponseDTO fromUser(User user, String jwt) {
        return new JWTAuthenticationResponseDTO(
                user.getId(),
                user.getFirstName(),
                user.getLastName(),
                user.getEmail(),
                user.getPhoneNumber(),
                user.getUserRole(),
                jwt
        );
    }
}
