package mk.ukim.finki.it.reservengo.service.impl;

import mk.ukim.finki.it.reservengo.model.domain.Local;
import mk.ukim.finki.it.reservengo.model.exceptions.LocalIdNotFoundException;
import mk.ukim.finki.it.reservengo.repository.LocalRepository;
import mk.ukim.finki.it.reservengo.service.intf.FileStorageService;
import mk.ukim.finki.it.reservengo.service.intf.LocalManagerService;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class LocalManagerServiceImpl implements LocalManagerService {

    private final LocalRepository localRepository;
    private final FileStorageService fileStorageService;

    public LocalManagerServiceImpl(LocalRepository localRepository, FileStorageService fileStorageService) {
        this.localRepository = localRepository;
        this.fileStorageService = fileStorageService;
    }

    @Override
    public void uploadLogo(Long localId, MultipartFile logoFile) {
        Local local = localRepository.findById(localId).orElseThrow(() -> new LocalIdNotFoundException(localId));

        String logoPath = fileStorageService.saveFile(logoFile);
        local.setLogoUrl(logoPath);

        localRepository.save(local);
    }
}
