package mk.ukim.finki.it.reservengo.dto.reservationDTO;

import mk.ukim.finki.it.reservengo.dto.tableDTO.TableInfoDTO;
import mk.ukim.finki.it.reservengo.model.domain.Reservation;
import mk.ukim.finki.it.reservengo.model.enumerations.ReservationStatus;

import java.time.LocalDateTime;
import java.util.List;

public record EditReservationInfoDTO(
        String localName,
        String localLogo,
        LocalDateTime currentTimeOfReservation,
        Long currentTableId,
        Integer currentTableNumber,
        ReservationStatus currentReservationStatus,
        List<TableInfoDTO> availableTables
) {
    public static EditReservationInfoDTO from(Reservation reservation, List<TableInfoDTO> availableTables) {
        return new EditReservationInfoDTO(
                reservation.getLocal().getName(),
                reservation.getLocal().getLogoUrl(),
                reservation.getTimeOfReservation(),
                reservation.getTable().getId(),
                reservation.getTable().getTableNumber(),
                reservation.getStatus(),
                availableTables
        );
    }
}
