package mk.ukim.finki.it.reservengo.model;

import jakarta.persistence.*;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import mk.ukim.finki.it.reservengo.model.enumerations.Position;
import mk.ukim.finki.it.reservengo.model.enumerations.Role;

@EqualsAndHashCode(callSuper = true)
@Entity
public class LocalWorker extends User {
    public LocalWorker(String firstName, String lastName, String email, String password, String phoneNumber, Role userRole) {
        super(firstName, lastName, email, password, phoneNumber, userRole);
    }

    public LocalWorker() {
    }

    @ManyToOne
    private Local local;

    @Enumerated(EnumType.STRING)
    private Position position;

    public Local getLocal() {
        return local;
    }

    public Position getPosition() {
        return position;
    }
}
