package mk.ukim.finki.it.reservengo.web;

import mk.ukim.finki.it.reservengo.model.Customer;
import mk.ukim.finki.it.reservengo.model.Local;
import mk.ukim.finki.it.reservengo.model.Reservation;
import mk.ukim.finki.it.reservengo.model.User;
import mk.ukim.finki.it.reservengo.service.intf.CustomerService;
import mk.ukim.finki.it.reservengo.service.intf.ReservationService;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/customer")
@PreAuthorize("hasRole('CUSTOMER')")
public class CustomerController {

    private final CustomerService customerService;
    private final ReservationService reservationService;

    public CustomerController(CustomerService customerService, ReservationService reservationService) {
        this.customerService = customerService;
        this.reservationService = reservationService;
    }

    @GetMapping("/profile")
    public ResponseEntity<?> getUserProfile(@AuthenticationPrincipal User user) {
        Customer userProfile = customerService.getCustomerProfile(user.getId());
        return ResponseEntity.ok(userProfile);
    }

    @GetMapping("/reservations")
    public ResponseEntity<?> getCustomerReservations(@AuthenticationPrincipal User user) {
        List<Reservation> customerReservations = reservationService.getCustomerReservations(user.getId());
        return ResponseEntity.ok(customerReservations);
    }

    @GetMapping("/favourite-locals")
    public ResponseEntity<?> listFavouriteLocals(@AuthenticationPrincipal User user) {
        List<Local> favouriteLocals = customerService.listFavouriteLocals(user.getId());
        return ResponseEntity.ok(favouriteLocals);
    }

    @PostMapping("/favourite-locals/add/{id}")
    public ResponseEntity<?> addFavouriteLocal(@AuthenticationPrincipal User user, @PathVariable Long id) {
        customerService.addFavouriteLocal(user.getId(), id);
        return ResponseEntity.ok().build();
    }

    @PostMapping("/favourite-locals/remove/{id}")
    public ResponseEntity<?> removeFavouriteLocal(@AuthenticationPrincipal User user, @PathVariable Long id) {
        customerService.removeFavouriteLocal(user.getId(), id);
        return ResponseEntity.ok().build();
    }
}
