package mk.ukim.finki.it.reservengo.web;

import mk.ukim.finki.it.reservengo.model.JWTAuthenticationResponse;
import mk.ukim.finki.it.reservengo.service.intf.AuthService;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/api/auth")
public class AuthController {
    private final AuthService authenticationService;

    public AuthController(AuthService authenticationService) {
        this.authenticationService = authenticationService;
    }

    @PostMapping(value = "/register/customer", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<JWTAuthenticationResponse> registerCustomer(@RequestParam String firstName,
                                                                      @RequestParam String lastName,
                                                                      @RequestParam String email,
                                                                      @RequestParam String password,
                                                                      @RequestParam String phoneNumber) {
        return new ResponseEntity<>(authenticationService.registerCustomer(firstName, lastName, email, password, phoneNumber), HttpStatus.CREATED);
    }

    @PostMapping("/register/local-worker")
    public ResponseEntity<JWTAuthenticationResponse> registerLocalWorker(@RequestParam String firstName,
                                                                         @RequestParam String lastName,
                                                                         @RequestParam String email,
                                                                         @RequestParam String password,
                                                                         @RequestParam String phoneNumber) {
        return new ResponseEntity<>(authenticationService.registerLocalWorker(firstName, lastName, email, password, phoneNumber), HttpStatus.CREATED);
    }

    @PostMapping("/register/local-manager")
    public ResponseEntity<JWTAuthenticationResponse> registerLocalManager(@RequestParam String firstName,
                                                                          @RequestParam String lastName,
                                                                          @RequestParam String email,
                                                                          @RequestParam String password,
                                                                          @RequestParam String phoneNumber) {
        return new ResponseEntity<>(authenticationService.registerLocalManager(firstName, lastName, email, password, phoneNumber), HttpStatus.CREATED);
    }

    @PostMapping("/login")
    public ResponseEntity<JWTAuthenticationResponse> login(@RequestParam String email,
                                                           @RequestParam String password) {
        return new ResponseEntity<>(authenticationService.login(email, password), HttpStatus.OK);
    }
}
