import { config } from '@/constants/Api_config'
import { HttpClient } from '@/Api_Classes/HttpClient'

const BASE_API_URL = config.API_BASE_URL

class TablesRepository {
  private readonly httpClient: HttpClient

  constructor(baseUrl: string) {
    this.httpClient = new HttpClient(baseUrl)
  }

  // GET /api/tables?localId=...&reservationTime=...
  getAvailableTables(localId: number | string, reservationTimeIso: string): Promise<any[]> {
    return this.httpClient.get(undefined, {
      queryParams: {
        localId: String(localId),
        reservationTime: reservationTimeIso,
      },
    })
  }
}

export const useTables = new TablesRepository(BASE_API_URL + '/api/tables')
