import { config } from '@/constants/Api_config'
import { HttpClient } from '@/Api_Classes/HttpClient'

const BASE_API_URL = config.API_BASE_URL

/*
console.warn("THIS IS THE BASE URL",BASE_API_URL)
*/

class Locale {
  private readonly httpClient: HttpClient

  constructor(baseUrl: string) {
    this.httpClient = new HttpClient(baseUrl)
  }

  getLocals(name?: string, sortBy?: string, direction?: string, isOpen?: boolean) {
    if (name || sortBy || direction) return this.httpClient.get("", { queryParams: { name, sortBy, direction, isOpen } })
    else return this.httpClient.get()
  }
  getSpecificLocale(localeId: number) {
    return this.httpClient.get(`${localeId}`)
  }

}

export const useLocales = new Locale(BASE_API_URL + '/api/locals', )
