
import { defineStore } from 'pinia'



export const userStore = defineStore('userStore', {

  state() {
    return {

      data: {
        id: 0,
        firstName: "",
        lastName: "",
        email: "",
        phoneNumber: "",
        role: "UN_AUTHENTICATED",
        token: ""
      }

    }
  },
  actions: {

    setLocalStorage(jsonObject) {
      //console.log("Local Storage object", jsonObject)

      this.data = jsonObject

      console.log("Local Storage data", this.data.firstName, this.data.lastName)

      localStorage.setItem('userData', JSON.stringify(jsonObject));

    },
    getLocalStorage() {
      let nonparsed = localStorage.getItem('userData');
      if (nonparsed !== null) {
        this.data = JSON.parse(nonparsed);
      }
    },
    clearLocalStorage() {

      this.data =  {
        id: 0,
        firstName: "",
        lastName: "",
        email: "",
        phoneNumber: "",
        role: "UN_AUTHENTICATED",
        token: ""
      }
      localStorage.setItem('userData', JSON.stringify(this.data));

    }



  },
  getters: {
    getToken(){
      return 'Bearer ' + this.data.token;
    }
  }






})
