package mk.ukim.finki.it.reservengo.web.controller;

import mk.ukim.finki.it.reservengo.dto.eventDTO.DisplayEventDTO;
import mk.ukim.finki.it.reservengo.dto.eventDTO.PagedEventDTO;
import mk.ukim.finki.it.reservengo.model.enumerations.EventStatus;
import mk.ukim.finki.it.reservengo.model.enumerations.EventType;
import mk.ukim.finki.it.reservengo.service.intf.EventService;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/api/events")
public class EventController {
    private final EventService eventService;

    public EventController(EventService eventService) {
        this.eventService = eventService;
    }

    @GetMapping
    public ResponseEntity<PagedEventDTO> getEvents(
            @RequestParam(required = false) String name,
            @RequestParam(required = false) EventType eventType,
            @RequestParam(required = false) EventStatus eventStatus, // active, upcoming
            @RequestParam(required = false, defaultValue = "name") String sortBy, // created at, name
            @RequestParam(required = false, defaultValue = "asc") String direction,
            @RequestParam(defaultValue = "0") int page,
            @RequestParam(defaultValue = "10") int size
    ) {
        Page<DisplayEventDTO> dtoPage = eventService.searchEvents(null, name, eventType, eventStatus, page, size, sortBy, direction);
        PagedEventDTO pagedEventDTO = PagedEventDTO.from(dtoPage);
        return new ResponseEntity<>(pagedEventDTO, HttpStatus.OK);
    }
}
