package mk.ukim.finki.it.reservengo.service.intf;

import mk.ukim.finki.it.reservengo.dto.eventDTO.CreateEventDTO;
import mk.ukim.finki.it.reservengo.dto.localDTO.CreateLocalDetailsDTO;
import mk.ukim.finki.it.reservengo.dto.localDTO.DeleteLocalPhotosResultDTO;
import mk.ukim.finki.it.reservengo.dto.localDTO.DisplayLocalDTO;
import mk.ukim.finki.it.reservengo.model.domain.Event;
import mk.ukim.finki.it.reservengo.model.domain.Local;
import mk.ukim.finki.it.reservengo.model.enumerations.LocalType;
import mk.ukim.finki.it.reservengo.model.enumerations.ProvidedService;
import org.springframework.data.domain.Page;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

public interface LocalService {
    List<Local> listAll();

    Local findLocalById(Long id);

    void save(String name);

    Local edit(Long localId, CreateLocalDetailsDTO createLocalDetailsDTO);

    void delete(Long id);

    String addLogo(Long localId, MultipartFile multipartFile);

    void deleteLogo(Long localId);

    String addPhoto(Long localId, MultipartFile photoFile);

    DeleteLocalPhotosResultDTO deletePhotos(Long localId, List<String> photoUrls);

    Page<DisplayLocalDTO> searchLocals(String name, List<ProvidedService> services, LocalType localType, Boolean isOpen, int page, int size, String sortBy, String direction);

    void addEvent(Local local, Event event);

    void deleteEvent(Local local, Event event);

    Event editEvent(Local local, Event event, CreateEventDTO createEventDTO);
}