package mk.ukim.finki.it.reservengo.model;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import mk.ukim.finki.it.reservengo.model.enumerations.Role;

import java.util.List;


@EqualsAndHashCode(callSuper = true)
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
public class Customer extends User {
    public Customer(String firstName,
                    String lastName,
                    String email,
                    String password,
                    String phoneNumber,
                    Role userRole) {
        super(firstName, lastName, email, password, phoneNumber, userRole);
    }

    @OneToMany(mappedBy = "customer", cascade = CascadeType.ALL)
    private List<Reservation> reservations;

    @OneToMany
    private List<Local> favouriteLocals;


}
