package mk.ukim.finki.it.reservengo.service.impl;

import mk.ukim.finki.it.reservengo.model.*;
import mk.ukim.finki.it.reservengo.model.enumerations.Role;
import mk.ukim.finki.it.reservengo.model.exceptions.EmailNotFoundException;
import mk.ukim.finki.it.reservengo.repository.CustomerRepository;
import mk.ukim.finki.it.reservengo.repository.LocalManagerRepository;
import mk.ukim.finki.it.reservengo.repository.LocalWorkerRepository;
import mk.ukim.finki.it.reservengo.repository.UserRepository;
import mk.ukim.finki.it.reservengo.service.intf.AuthService;
import mk.ukim.finki.it.reservengo.service.intf.JWTService;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class AuthServiceImpl implements AuthService {
    private final CustomerRepository customerRepository;
    private final LocalWorkerRepository localWorkerRepository;
    private final LocalManagerRepository localManagerRepository;
    private final JWTService jwtService;
    private final PasswordEncoder passwordEncoder;
    private final AuthenticationManager authenticationManager;
    private final UserRepository userRepository;

    public AuthServiceImpl(CustomerRepository customerRepository, LocalWorkerRepository localWorkerRepository, LocalManagerRepository localManagerRepository, JWTService jwtService, PasswordEncoder passwordEncoder, AuthenticationManager authenticationManager, UserRepository userRepository) {
        this.customerRepository = customerRepository;
        this.localWorkerRepository = localWorkerRepository;
        this.localManagerRepository = localManagerRepository;
        this.jwtService = jwtService;
        this.passwordEncoder = passwordEncoder;
        this.authenticationManager = authenticationManager;
        this.userRepository = userRepository;
    }

    @Override
    public JWTAuthenticationResponse registerCustomer(String firstName, String lastName, String email, String password, String phoneNumber) {
        Customer customer = new Customer(firstName, lastName, email, passwordEncoder.encode(password), phoneNumber, Role.CUSTOMER);
        customerRepository.save(customer);
        Customer customer1 = customerRepository.findByEmail(email).orElseThrow(() -> new EmailNotFoundException(email));
        String jwt = jwtService.generateTokenNoClaims(customer);
        System.out.println(jwt);
        System.out.println(customer1);
        return new JWTAuthenticationResponse(
                customer1.getId(),
                customer1.getFirstName(),
                customer1.getLastName(),
                customer1.getEmail(),
                customer1.getPhoneNumber(),
                Role.CUSTOMER,
                jwt);
    }

    @Override
    public JWTAuthenticationResponse registerLocalWorker(String firstName, String lastName, String email, String password, String phoneNumber) {
        LocalWorker localWorker = new LocalWorker(firstName, lastName, email, passwordEncoder.encode(password), phoneNumber, Role.LOCAL_WORKER);
        localWorkerRepository.save(localWorker);
        LocalWorker localWorker1 = localWorkerRepository.findByEmail(email).orElseThrow(() -> new EmailNotFoundException(email));
        String jwt = jwtService.generateTokenNoClaims(localWorker);

        return new JWTAuthenticationResponse(
                localWorker1.getId(),
                localWorker1.getFirstName(),
                localWorker1.getLastName(),
                localWorker1.getEmail(),
                localWorker1.getPhoneNumber(),
                Role.LOCAL_WORKER,
                jwt);
    }

    @Override
    public JWTAuthenticationResponse registerLocalManager(String firstName, String lastName, String email, String password, String phoneNumber) {
        LocalManager localManager = new LocalManager(firstName, lastName, email, passwordEncoder.encode(password), phoneNumber, Role.LOCAL_MANAGER);
        localManagerRepository.save(localManager);
        LocalManager localManager1 = localManagerRepository.findByEmail(email).orElseThrow(() -> new EmailNotFoundException(email));
        String jwt = jwtService.generateTokenNoClaims(localManager);

        return new JWTAuthenticationResponse(
                localManager1.getId(),
                localManager1.getFirstName(),
                localManager1.getLastName(),
                localManager1.getEmail(),
                localManager1.getPhoneNumber(),
                Role.LOCAL_MANAGER,
                jwt);
    }

    @Override
    public JWTAuthenticationResponse login(String email, String password) {
        authenticationManager.authenticate(new UsernamePasswordAuthenticationToken(email,password));
        User user = userRepository.findByEmail(email).orElseThrow(() -> new EmailNotFoundException(email));
        String jwt = jwtService.generateTokenNoClaims(user);
        System.out.println(jwt);
        System.out.println(user);
        return new JWTAuthenticationResponse(
                user.getId(),
                user.getFirstName(),
                user.getLastName(),
                user.getEmail(),
                user.getPhoneNumber(),
                user.getUserRole(),
                jwt);
    }

}
