package mk.ukim.finki.it.reservengo.bootstrap;

import jakarta.annotation.PostConstruct;
import mk.ukim.finki.it.reservengo.model.*;
import mk.ukim.finki.it.reservengo.model.enumerations.*;
import mk.ukim.finki.it.reservengo.repository.*;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
public class DataHolder {
    public static Admin admin = null;
    public static List<Customer> customers = new ArrayList<>();
    public static List<LocalWorker> workers = new ArrayList<>();
    public static List<LocalManager> managers = new ArrayList<>();
    public static List<Event> events = new ArrayList<>();
    public static List<Reservation> reservations = new ArrayList<>();
    public static List<Local> locals = new ArrayList<>();

    private final AdminRepository adminRepository;
    private final CustomerRepository customerRepository;
    private final EventRepository eventRepository;
    private final LocalManagerRepository localManagerRepository;
    private final LocalRepository localRepository;
    private final LocalWorkerRepository localWorkerRepository;
    private final ReservationRepository reservationRepository;
    private final PasswordEncoder passwordEncoder;

    public DataHolder(AdminRepository adminRepository, CustomerRepository customerRepository, EventRepository eventRepository, LocalManagerRepository localManagerRepository, LocalRepository localRepository, LocalWorkerRepository localWorkerRepository, ReservationRepository reservationRepository, PasswordEncoder passwordEncoder) {
        this.adminRepository = adminRepository;
        this.customerRepository = customerRepository;
        this.eventRepository = eventRepository;
        this.localManagerRepository = localManagerRepository;
        this.localRepository = localRepository;
        this.localWorkerRepository = localWorkerRepository;
        this.reservationRepository = reservationRepository;
        this.passwordEncoder = passwordEncoder;
    }

    @PostConstruct
    public void init() {
        // Admin
        admin = new Admin("admin", passwordEncoder.encode("admin"), Role.ADMIN);
        adminRepository.save(admin);

        // Customers
        for (int i = 1; i <= 3; i++) {
            Customer customer = new Customer(
                    "Customer " + i,
                    "Customer " + i,
                    "customer" + i + "@example.com",
                    passwordEncoder.encode("password" + i),
                    "Phone" + i,
                    Role.CUSTOMER
            );
            customers.add(customer);
        }
        customerRepository.saveAll(customers);

        // Print for debugging purposes
        System.out.println("Initialization complete!");
    }
}