package mk.ukim.finki.it.reservengo.service.impl;

import mk.ukim.finki.it.reservengo.dto.userDTO.CreateUserDTO;
import mk.ukim.finki.it.reservengo.model.domain.User;
import mk.ukim.finki.it.reservengo.model.exceptions.CustomerNotFoundException;
import mk.ukim.finki.it.reservengo.repository.UserRepository;
import mk.ukim.finki.it.reservengo.service.intf.UserService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImpl implements UserService {

    private final UserRepository userRepository;
    private final PasswordEncoder passwordEncoder;

    public UserServiceImpl(UserRepository userRepository, PasswordEncoder passwordEncoder) {
        this.userRepository = userRepository;
        this.passwordEncoder = passwordEncoder;
    }

    @Override
    public User findUser(Long userId) {
        return userRepository.findById(userId).orElseThrow(() -> new CustomerNotFoundException(userId));
    }

    @Override
    public User editUserInfo(Long userId, CreateUserDTO createUserDTO) {
        User user = findUser(userId);
        updateUserFromDto(user, createUserDTO);
        return userRepository.save(user);
    }

    private void updateUserFromDto(User user, CreateUserDTO createUserDTO) {
        if (createUserDTO.firstName() != null) {
            user.setFirstName(createUserDTO.firstName());
        }
        if (createUserDTO.lastName() != null) {
            user.setLastName(createUserDTO.lastName());
        }
        if (createUserDTO.email() != null) {
            user.setEmail(createUserDTO.email());
        }
        if (createUserDTO.password() != null && !createUserDTO.password().isEmpty()) {
            user.setPassword(passwordEncoder.encode(createUserDTO.password()));
        }
        if (createUserDTO.phoneNumber() != null) {
            user.setPhoneNumber(createUserDTO.phoneNumber());
        }
    }
}
