package mk.ukim.finki.it.reservengo.service.impl;

import com.twilio.rest.api.v2010.account.Message;
import com.twilio.type.PhoneNumber;
import mk.ukim.finki.it.reservengo.config.TwilioConfig;
import mk.ukim.finki.it.reservengo.service.intf.SmsService;
import org.springframework.stereotype.Service;

@Service
public class SmsServiceImpl implements SmsService {
    private final TwilioConfig config;

    public SmsServiceImpl(TwilioConfig config) {
        this.config = config;
    }

    public void sendSms(String to, String text) {
        Message.creator(
                new PhoneNumber(to),
                new PhoneNumber(config.getPhoneNumber()),
                text
        ).create();
    }
}
