package mk.ukim.finki.it.reservengo.web.controller;

import mk.ukim.finki.it.reservengo.service.intf.LocalManagerService;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

@RestController
@RequestMapping("/api/local-manager")
public class LocalManagerController {

    private final LocalManagerService localManagerService;

    public LocalManagerController(LocalManagerService localManagerService) {
        this.localManagerService = localManagerService;
    }

    @PostMapping("/{localId}/upload-logo")
    public ResponseEntity<?> uploadLogo(@PathVariable Long localId,
                                        @RequestParam("logo") MultipartFile logoFile) {
        localManagerService.uploadLogo(localId, logoFile);
        return ResponseEntity.ok().build();
    }

    @DeleteMapping("/{localId}/delete-logo")
    public ResponseEntity<?> deleteLocalLogo(@PathVariable Long localId) {
        localManagerService.deleteLocalLogo(localId);
        return ResponseEntity.ok().build();
    }

    @PostMapping("/{localId}/upload-photos")
    public ResponseEntity<?> uploadPhotos(@PathVariable Long localId,
                                          @RequestParam("photos") List<MultipartFile> photos) {
        localManagerService.uploadPhotos(localId, photos);
        return ResponseEntity.ok().build();
    }

}
