package mk.ukim.finki.it.reservengo.service.impl;

import mk.ukim.finki.it.reservengo.service.intf.FileStorageService;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.UUID;

@Service
public class FileStorageServiceImpl implements FileStorageService {

    private final Path rootUploadsDir = Paths.get("uploads");
    private final Path logosDir = rootUploadsDir.resolve("logos");
    private final Path localsDir = rootUploadsDir.resolve("locals");

    public FileStorageServiceImpl() throws IOException {
        Files.createDirectories(rootUploadsDir);
        Files.createDirectories(logosDir);
        Files.createDirectories(localsDir);
    }

    @Override
    public String saveLogoFile(MultipartFile file) {
        try {
            String fileName = UUID.randomUUID() + "_" + file.getOriginalFilename();
            Path target = logosDir.resolve(fileName);
            Files.copy(file.getInputStream(), target, StandardCopyOption.REPLACE_EXISTING);
            return "/uploads/logos/" + fileName;
        } catch (IOException e) {
            throw new RuntimeException("Failed to save logo", e);
        }
    }

    @Override
    public String saveLocalPhoto(Long localId, MultipartFile file) {
        try {
            Path localFolder = localsDir.resolve(String.valueOf(localId));
            Files.createDirectories(localFolder);
            String fileName = UUID.randomUUID() + "_" + file.getOriginalFilename();
            Path target = localFolder.resolve(fileName);
            Files.copy(file.getInputStream(), target, StandardCopyOption.REPLACE_EXISTING);
            return "/uploads/locals/" + localId + "/" + fileName;
        } catch (IOException e) {
            throw new RuntimeException("Failed to save local photo", e);
        }
    }
}
