package mk.ukim.finki.it.reservengo.service.intf;

import mk.ukim.finki.it.reservengo.dto.userDTO.*;
import mk.ukim.finki.it.reservengo.model.domain.User;
import org.springframework.web.multipart.MultipartFile;

public interface UserService {
    User findUserById(Long userId);

    User editUser(Long userId, EditUserProfileDTO editUserProfileDTO);

    User findUserByEmail(String email);

    boolean emailExists(String email);

    DisplayUserEmailDTO changeEmail(Long userId, EditUserEmailDTO editUserEmailDTO);

    void changePassword(Long userId, EditUserPasswordDTO editUserPasswordDTO);

    String uploadProfilePhoto(Long id, MultipartFile photoFile);

    void deleteProfilePhoto(Long id);
}
