package mk.ukim.finki.it.reservengo.dto.userDTO;

import mk.ukim.finki.it.reservengo.model.domain.User;
import mk.ukim.finki.it.reservengo.model.enumerations.Role;

import java.util.List;

public record DisplayUserDTO(
        Long id,
        String firstName,
        String lastName,
        String email,
        String phoneNumber,
        Role role,
        String profilePhoto
) {
    public static DisplayUserDTO fromUser(User user) {
        return new DisplayUserDTO(
                user.getId(),
                user.getFirstName(),
                user.getLastName(),
                user.getEmail(),
                user.getPhoneNumber(),
                user.getUserRole(),
                user.getProfilePhotoUrl()
        );
    }

    public static List<DisplayUserDTO> fromUsers(List<? extends User> users) {
        return users.stream()
                .map(DisplayUserDTO::fromUser)
                .toList();
    }
}
