package mk.ukim.finki.it.reservengo.web.controller;

import mk.ukim.finki.it.reservengo.dto.localDTO.CreateLocalDetailsDTO;
import mk.ukim.finki.it.reservengo.dto.localDTO.DisplayLocalDetailsDTO;
import mk.ukim.finki.it.reservengo.model.domain.User;
import mk.ukim.finki.it.reservengo.service.intf.LocalManagerService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping("/api/local-manager")
@PreAuthorize("hasRole('LOCAL_MANAGER')")
public class LocalManagerController {

    private final LocalManagerService localManagerService;

    public LocalManagerController(LocalManagerService localManagerService) {
        this.localManagerService = localManagerService;
    }

    @GetMapping("/my-local")
    public ResponseEntity<DisplayLocalDetailsDTO> getLocalForManager(@AuthenticationPrincipal User user) {
        DisplayLocalDetailsDTO displayLocalDetailsDTO = DisplayLocalDetailsDTO.from(localManagerService.findLocalByManagerId(user.getId()));
        return new ResponseEntity<>(displayLocalDetailsDTO, HttpStatus.OK);
    }

    @PutMapping("/my-local/edit")
    public ResponseEntity<DisplayLocalDetailsDTO> editLocalInformation(@AuthenticationPrincipal User user, @RequestBody CreateLocalDetailsDTO createLocalDetailsDTO) {
        DisplayLocalDetailsDTO displayLocalDetailsDTO = DisplayLocalDetailsDTO.from(localManagerService.editLocal(user.getId(), createLocalDetailsDTO));
        return new ResponseEntity<>(displayLocalDetailsDTO, HttpStatus.OK);
    }

    @PostMapping("/upload-logo")
    public ResponseEntity<String> uploadLogo(@AuthenticationPrincipal User user,
                                           @RequestParam("logo") MultipartFile logoFile) {
        String logoUrl = localManagerService.uploadLocalLogo(user.getId(), logoFile);
        return new ResponseEntity<>(logoUrl, HttpStatus.OK);
    }

    @DeleteMapping("/delete-logo")
    public ResponseEntity<Void> deleteLocalLogo(@AuthenticationPrincipal User user) {
        localManagerService.deleteLocalLogo(user.getId());
        return new ResponseEntity<>(HttpStatus.OK);
    }
//
//    @PostMapping("/{localId}/upload-photos")
//    public ResponseEntity<Void> uploadLocalPhotos(@PathVariable Long localId,
//                                             @RequestParam("photos") List<MultipartFile> photos) {
//        localManagerService.uploadLocalPhotos(localId, photos);
//        return new ResponseEntity<>(HttpStatus.NO_CONTENT);
//    }
//
//    @DeleteMapping("/{localId}/delete-photos")
//    public ResponseEntity<Void> deleteLocalPhotos(@PathVariable Long localId,
//                                             @RequestParam("photos") List<String> photoPaths) {
//        localManagerService.deleteLocalPhotos(localId, photoPaths);
//        return new ResponseEntity<>(HttpStatus.NO_CONTENT);
//    }
}
