package mk.ukim.finki.it.reservengo.model.domain;

import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Embeddable;
import jakarta.persistence.MapKeyColumn;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Map;

@Data
//@AllArgsConstructor
@NoArgsConstructor
@Embeddable
public class Contact {
    private String phone;
    private String email;
    @ElementCollection
    @MapKeyColumn(name = "soical_app_name")
    @Column(name = "social_app_link")
    private Map<String, String> socialLinks;

    public Contact(String phone, String email, Map<String, String> socialLinks) {
        this.phone = phone;
        this.email = email;
        this.socialLinks = socialLinks;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Map<String, String> getSocialLinks() {
        return socialLinks;
    }

    public void setSocialLinks(Map<String, String> socialLinks) {
        this.socialLinks = socialLinks;
    }
}
