package mk.ukim.finki.it.reservengo.web;

import mk.ukim.finki.it.reservengo.dto.adminDTO.AdminDTO;
import mk.ukim.finki.it.reservengo.service.intf.AdminService;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/api/admin")
@PreAuthorize("hasRole('ADMIN')")
public class AdminController {

    private final AdminService adminService;

    public AdminController(AdminService adminService) {
        this.adminService = adminService;
    }

    @PostMapping("/add")
    public ResponseEntity<?> addLocal(@RequestBody AdminDTO adminDTO) {
        adminService.addLocal(adminDTO);
        return ResponseEntity.ok().build();
    }

    @PostMapping("/delete/{id}")
    public ResponseEntity<?> deleteLocal(@PathVariable Long id) {
        adminService.deleteLocal(id);
        return ResponseEntity.ok().build();
    }
}
