package mk.ukim.finki.it.reservengo.dto.jwtDTO;

import mk.ukim.finki.it.reservengo.model.domain.JWTAuthentication;
import mk.ukim.finki.it.reservengo.model.enumerations.Role;


public record JWTAuthenticationResponseDTO(
        Long id,
        String firstName,
        String lastName,
        String email,
        String phoneNumber,
        Role role,
        String token
) {
    public static JWTAuthenticationResponseDTO from(JWTAuthentication jwtAuthentication) {
        return new JWTAuthenticationResponseDTO(
                jwtAuthentication.getId(),
                jwtAuthentication.getFirstName(),
                jwtAuthentication.getLastName(),
                jwtAuthentication.getEmail(),
                jwtAuthentication.getPhoneNumber(),
                jwtAuthentication.getRole(),
                jwtAuthentication.getToken()
        );
    }
}
