package mk.ukim.finki.it.reservengo.model.domain;

import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.ManyToOne;
import lombok.EqualsAndHashCode;
import mk.ukim.finki.it.reservengo.model.enumerations.Position;
import mk.ukim.finki.it.reservengo.model.enumerations.Role;

@EqualsAndHashCode(callSuper = true)
@Entity
public class LocalWorker extends User {
    public LocalWorker(String firstName, String lastName, String email, String password, String phoneNumber, Role userRole) {
        super(firstName, lastName, email, password, phoneNumber, userRole);
    }

    public LocalWorker(String firstName, String lastName, String email, String password, String phoneNumber, Role userRole, Position position, Local local) {
        super(firstName, lastName, email, password, phoneNumber, userRole);
        this.position = position;
        this.local = local;
    }

    public LocalWorker() {
    }

    @ManyToOne
    private Local local;

    @Enumerated(EnumType.STRING)
    private Position position;

    public Local getLocal() {
        return local;
    }

    public Position getPosition() {
        return position;
    }
}
