package mk.ukim.finki.it.reservengo.service.impl;

import mk.ukim.finki.it.reservengo.dto.adminDTO.AdminDTO;
import mk.ukim.finki.it.reservengo.model.domain.Local;
import mk.ukim.finki.it.reservengo.model.exceptions.LocalNotFoundException;
import mk.ukim.finki.it.reservengo.repository.LocalRepository;
import mk.ukim.finki.it.reservengo.service.intf.AdminService;
import org.springframework.stereotype.Service;

@Service
public class AdminServiceImpl implements AdminService {

    private final LocalRepository localRepository;

    public AdminServiceImpl(LocalRepository localRepository) {
        this.localRepository = localRepository;
    }

    @Override
    public void addLocal(AdminDTO adminDTO) {
        Local local = new Local(adminDTO.name());
        localRepository.save(local);
    }

    @Override
    public void deleteLocal(Long id) {
        Local local = localRepository.findById(id).orElseThrow(() -> new LocalNotFoundException(id));
        localRepository.delete(local);
    }
}
