package mk.ukim.finki.it.reservengo.config.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.NonNull;
import mk.ukim.finki.it.reservengo.constants.JWTConstants;
import mk.ukim.finki.it.reservengo.service.intf.JWTService;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

import java.io.IOException;

@Component
public class InviteFilter extends OncePerRequestFilter {
    private final JWTService jwtService;

    public InviteFilter(JWTService jwtService) {
        this.jwtService = jwtService;
    }

    @Override
    protected void doFilterInternal(@NonNull HttpServletRequest request,
                                    @NonNull HttpServletResponse response,
                                    @NonNull FilterChain filterChain) throws ServletException, IOException {
        String token = request.getHeader(JWTConstants.INVITE_TOKEN_HEADER);
        String path = request.getRequestURI();


        if (path.contains("/register/local-manager") || path.contains("/register/local-worker") || path.contains("/register/invite/check")) {

            //Solution for bug
            if (request.getMethod().equals("OPTIONS")) {
                filterChain.doFilter(request, response);
                return;
            }
            //Solution for bug

            if (token == null || token.isEmpty()) {
                response.setStatus(HttpServletResponse.SC_UNAUTHORIZED);
                return;
            }

            if (jwtService.isTokenExpired(token)) {
                response.setStatus(HttpServletResponse.SC_UNAUTHORIZED);
                return;
            }

            String role = jwtService.extractAllClaims(token).get("role", String.class);

            if (path.contains("/local-manager") && !role.equals("ROLE_LOCAL_MANAGER")) {
                response.setStatus(HttpServletResponse.SC_FORBIDDEN);
                return;
            }

            if (path.contains("/local-worker") && !role.equals("ROLE_LOCAL_WORKER")) {
                response.setStatus(HttpServletResponse.SC_FORBIDDEN);
                return;
            }
        }

        filterChain.doFilter(request, response);
    }
}
