import { config } from '@/constants/Api_config'
import { HttpClient } from '@/Api_Classes/HttpClient'

const BASE_API_URL = config.API_BASE_URL

class LocalManager {
  private readonly httpClient: HttpClient

  constructor(baseUrl: string) {
    this.httpClient = new HttpClient(baseUrl)
  }

  getMyLocal(): Promise<any> {
    return this.httpClient.get('my-local');
  }

  getLocalWorkers(): Promise<any[]> {
    return this.httpClient.get('local-workers');
  }

  getAvailableWorkers(): Promise<any[]> {
    return this.httpClient.get('workers');
  }

  assignWorker(workerId: string): Promise<any> {
    return this.httpClient.post(`assign/${workerId}`, {});
  }

  removeWorker(workerId: string): Promise<any> {
    return this.httpClient.delete(`remove/${workerId}`);
  }

  changeWorkerPosition(workerId: string, position: string): Promise<any> {
    return this.httpClient.put(`change-position/${workerId}`, { position });
  }

  uploadLogo(formData: FormData): Promise<any> {
    return this.httpClient.upload('upload-logo', formData)
  }
  uploadImage(formData: FormData): Promise<any> {
    return this.httpClient.upload('upload-photo', formData)
  }
  deletePhoto(photoUrls : Object): Promise<any> {
    return this.httpClient.delete('delete-photos', photoUrls)
  }
  saveDetailChanges(payload): Promise<any> {
    return this.httpClient.put('my-local/edit', payload);
  }
  addEvent(formData: FormData): Promise<any> {
    return this.httpClient.post('add-event', formData)
  }
  updateEvent(formData: FormData, eventId): Promise<any> {
    return this.httpClient.put(`events/edit/${eventId}`, formData)
  }
  deleteEvent(eventId): Promise<any> {
    return this.httpClient.delete(`delete-event/${eventId}`)
  }
  inviteWorker(newEmail: string) : Promise<any> {
    return this.httpClient.post('invite-worker', { newEmail })
  }
}

export const useLocalManager = new LocalManager(BASE_API_URL + '/api/local-manager/')
