// Generic fallback
export function enumToLabel(value?: string): string {
  if (!value) return ''

  return value
    .toLowerCase()
    .split('_')
    .map((word) => word.charAt(0).toUpperCase() + word.slice(1))
    .join(' ')
}

export const EnumLabelMaps = {
  LocalType: {
    RESTAURANT: 'Restaurant',
    CAFE: 'Cafe',
    BAR: 'Bar',
    PUB: 'Pub',
    BISTRO: 'Bistro',
    FOOD_TRUCK: 'Food truck',
    BUFFET: 'Buffet',
    FAST_FOOD: 'Fast food',
    LOUNGE: 'Lounge',
    DELI: 'Deli',
  },
  EventType: {
    DJ_NIGHT: 'DJ night',
    LIVE_MUSIC: 'Live music',
    FOOD_SPECIAL: 'Food special',
    DRINK_SPECIAL: 'Drink special',
    HAPPY_HOUR: 'Happy hour',
    SPORTS_SCREENING: 'Sports screening',
    KARAOKE: 'Karaoke',
    THEME_PARTY: 'Theme party',
    OPEN_MIC: 'Open mic',
    COOKING_WORKSHOP: 'Cooking workshop',
    ART_EXHIBITION: 'Art exhibition',
    COMEDY_SHOW: 'Comedy show',
    GAME_NIGHT: 'Game night',
    PRIVATE_EVENT: 'Private event',
    SEASONAL_EVENT: 'Seasonal event',
  },
  ProvidedService: {
    WIFI: 'Wi-Fi',
    PET_FRIENDLY: 'Pet friendly',
    FAMILY_KIDS_FRIENDLY: 'Family & kids friendly',
    PARKING: 'Parking',
    OUTDOOR: 'Outdoor seating',
    INDOOR: 'Indoor seating',
    PLAYGROUND: 'Playground',
    VEGAN_FRIENDLY: 'Vegan friendly',
    VEGETARIAN_FRIENDLY: 'Vegetarian friendly',
    GLUTEN_FREE_FRIENDLY: 'Gluten free friendly',
    SMOKING_FRIENDLY: 'Smoking friendly',
  },
} as const

export type EnumGroup = keyof typeof EnumLabelMaps

export function getEnumLabel(enumValue: string | undefined, enumGroup?: EnumGroup): string {
  if (!enumValue) return ''

  if (enumGroup && EnumLabelMaps[enumGroup] && EnumLabelMaps[enumGroup][enumValue]) {
    return EnumLabelMaps[enumGroup][enumValue as keyof (typeof EnumLabelMaps)[typeof enumGroup]]
  }

  return enumToLabel(enumValue)
}

export function getEnumOptions(enumGroup?: EnumGroup): Array<{ value: string; label: string }> {
  if (!enumGroup || !EnumLabelMaps[enumGroup]) return []
  return Object.keys(EnumLabelMaps[enumGroup]).map((k) => ({
    value: k,
    label: (EnumLabelMaps[enumGroup] as Record<string, string>)[k],
  }))
}
