package mk.ukim.finki.it.reservengo.model;

import jakarta.persistence.*;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import mk.ukim.finki.it.reservengo.model.enumerations.EventStatus;

import java.time.LocalDateTime;

@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
public class Event {
    public Event(String name, String description, LocalDateTime eventStart, LocalDateTime eventEnd, Local local, EventStatus status) {
        this.name = name;
        this.description = description;
        this.eventStart = eventStart;
        this.eventEnd = eventEnd;
        this.local = local;
        this.status = status;
    }

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    private String name;

    private String description;

    private LocalDateTime eventStart;

    private LocalDateTime eventEnd;

    @ManyToOne
    private Local local;

    @Enumerated(EnumType.STRING)
    private EventStatus status;
}
