package mk.ukim.finki.it.reservengo.model;

import jakarta.persistence.*;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import mk.ukim.finki.it.reservengo.model.enumerations.ReservationStatus;

import java.time.LocalDateTime;
import java.util.Map;

@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
public class Reservation {
    public Reservation(Customer customer, Local local, LocalDateTime timeOfRes, Map<Integer, Integer> reservedTables, ReservationStatus status) {
        this.customer = customer;
        this.local = local;
        this.timeOfRes = timeOfRes;
        this.reservedTables = reservedTables;
        this.status = status;
    }

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @ManyToOne
    private Customer customer;

    @ManyToOne
    private Local local;

    private LocalDateTime timeOfRes;

    @ElementCollection
    @MapKeyColumn(name = "table_id")
    @Column(name = "num_people")
    private Map<Integer, Integer> reservedTables;

    @Enumerated(EnumType.STRING)
    private ReservationStatus status;
}
