package mk.ukim.finki.it.reservengo.model;

import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Embeddable;
import jakarta.persistence.MapKeyColumn;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Map;

@Data
@NoArgsConstructor
@Embeddable
public class Contact {
    public Contact(String phone, String email, Map<String, String> socialLinks) {
        this.phone = phone;
        this.email = email;
        this.socialLinks = socialLinks;
    }

    private String phone;
    private String email;
    @ElementCollection
    @MapKeyColumn(name = "soical_app_name")
    @Column(name = "social_app_link")
    private Map<String, String> socialLinks;
}
